#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

from pathlib import Path

import tripleblind as tb
from tripleblind import session


tb.util.set_script_dir_current()
data_dir = Path("example_data")
run_id = tb.util.read_run_id()

tb.initialize(api_token=tb.config.example_user3["token"])

try:
    print("Uploading table a to organization-three's Access Point...")
    asset0 = tb.Asset.position(
        data_dir / "ratings0.csv",
        name=f"ratings0-{run_id}",
        desc="Set of ratings for recommender model",
        is_discoverable=True,
    )

    if tb.config.create_agreements_on_example_input_assets:
        # For this example we will attach an Agreement to the datasets.  This
        # agreement makes the dataset available to any team, which
        # means the training step will not require the dataset owner to
        # explicitly grant permission for use.
        asset0.add_agreement(
            with_team=tb.config.example_user1["team_id"],
            operation=tb.Operation.RECOMMENDER_TRAIN,
        )
        print("Created wildcard Agreement")
except tb.TripleblindAssetAlreadyExists:
    print(
        f"Asset 'ratings0-{run_id}' already exists, change value in run_id.txt to make it unique."
    )

session2 = session.Session(
    api_token=tb.config.example_user2["token"], from_default=True
)
try:
    print("Uploading table a to organization-two's Access Point...")
    asset1 = tb.Asset.position(
        data_dir / "ratings1.csv",
        name=f"ratings1-{run_id}",
        desc="Set of ratings for recommender model",
        is_discoverable=True,
        session=session2,
    )

    if tb.config.create_agreements_on_example_input_assets:
        # For this example we will attach an Agreement to the datasets.  This
        # agreement makes the dataset available to any team, which
        # means the training step will not require the dataset owner to
        # explicitly grant permission for use.
        asset1.add_agreement(
            with_team=tb.config.example_user1["team_id"],
            operation=tb.Operation.RECOMMENDER_TRAIN,
            session=session2,
        )
        print("Created wildcard Agreement")
except tb.TripleblindAssetAlreadyExists:
    print(
        f"Asset 'ratings1-{run_id}' already exists, change value in run_id.txt to make it unique."
    )
