#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

from pathlib import Path

import tripleblind as tb


tb.util.set_script_dir_current()
data_dir = Path("example_data")

run_id = tb.util.read_run_id()

tb.initialize(api_token=tb.config.example_user1["token"])
session_org_1 = tb.Session(
    api_token=tb.config.example_user1["token"], from_default=True
)

try:
    print("Uploading 'JPM Customers' to organization-one's Access Point...")
    asset_0 = tb.Asset.position(
        file_handle=data_dir / "psi_data0.csv",
        name=f"JPM Customers-{run_id}",
        desc="Fictional JPM account identifiers.",
        is_discoverable=True,
        session=session_org_1,
    )
    if tb.config.create_agreements_on_example_input_assets:
        # For this example we will attach an Agreement to the datasets.  This
        # agreement makes the dataset available to the other team,
        # meaning the PSI step will not require the dataset owner to
        # explicitly grant permission for use.
        asset_0.add_agreement(
            with_team=tb.config.example_user3["team_id"],
            operation=tb.Operation.PRIVATE_SET_INTERSECTION,
            session=session_org_1,
        )
        print("Created Agreement")
except tb.TripleblindAssetAlreadyExists:
    print(
        f"Asset 'JPM Customers-{run_id}' already exists, change value in run_id.txt to make it unique.'"
    )


session_org_2 = tb.Session(
    api_token=tb.config.example_user2["token"], from_default=True
)

try:
    print("Uploading 'PNB Customers' to organization-two's Access Point...")
    asset_1 = tb.Asset.position(
        file_handle=data_dir / "psi_data1.csv",
        name=f"PNB Customers-{run_id}",
        desc="Fictional PNB Customers.",
        is_discoverable=True,
        session=session_org_2,
    )

    if tb.config.create_agreements_on_example_input_assets:
        # For this example we will attach an Agreement to the datasets.  This
        # agreement makes the dataset available to the other team,
        # meaning the PSI step will not require the dataset owner to
        # explicitly grant permission for use.
        asset_1.add_agreement(
            with_team=tb.config.example_user3["team_id"],
            operation=tb.Operation.PRIVATE_SET_INTERSECTION,
            session=session_org_2,
        )
        print("Created Agreement")
except tb.TripleblindAssetAlreadyExists:
    print(
        f"Asset 'PNB Customers-{run_id}' already exists, change value in run_id.txt to make it unique.'"
    )


session_org_3 = tb.Session(
    api_token=tb.config.example_user3["token"], from_default=True
)

try:
    print("Uploading 'Brokerage licenses' to organization-three's Access Point...")
    asset_2 = tb.Asset.position(
        file_handle=data_dir / "psi_data2.csv",
        name=f"Broker licenses-{run_id}",
        desc="Fictional broker's licenses.",
        is_discoverable=True,
        session=session_org_3,
    )

    # if tb.config.create_agreements_on_example_input_assets:
    #     asset_2.add_agreement(
    #         with_team=tb.config.example_user3["team_id"],
    #         operation=tb.Operation.PRIVATE_SET_INTERSECTION,
    #         session=session_org_3,
    #     )
    #     print("Created Agreement")
except tb.TripleblindAssetAlreadyExists:
    print(
        f"Asset 'Brokerage licenses-{run_id}' already exists, change value in run_id.txt to make it unique.'"
    )

print("Data is in position.")
