library(pmml)
library(randomForest)
data(iris)
set.seed(11)

# Train random forest model
model <- randomForest(Species ~ ., data=iris, importance=TRUE, proximity=TRUE, ntree=20)

# Convert to PMML and serialize to XML file
export <- pmml(model);
save_pmml(export, "iris-randomForest-R.xml")
