#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import os

import tripleblind as tb


tb.util.set_script_dir_current()
tb.initialize(api_token=tb.config.example_user1["token"])
run_id = tb.util.read_run_id()
model_file = "pmml.xml"

if os.environ.get("TB_TEST_SMALL"):
    name = f"TEST - PMML Logistic Regression model - {run_id}"
else:
    name = "EXAMPLE - PMML Logistic Regression model"

description = "Simple model for predicting loan default rates."

print(
    f"Positioning '{model_file}' as {name} on {tb.config.example_user1['login']}'s Access Point..."
)
try:
    model = tb.asset.PMMLRegression.create(
        model_file, name=name, desc=description, allow_overwrite=True
    )
except:
    print(f"   Asset '{name}' already exists.'")
    model = tb.Asset.find(name, owned_by=tb.config.example_user1["team_id"])


# Attach an Agreement to the algorithm.  This agreement makes the algorithm
# available to the other team, which means the inference step will not
# require the algorithm owner to explicitly grant permission for use.  Usage is
# still logged for auditing.
model.add_agreement(
    with_team=tb.config.example_user3["team_id"], operation=tb.Operation.EXECUTE
)
print(f"Created Agreement with '{tb.config.example_user3['login']}'")


# Save for use in 2_remote_inference.py
tb.util.save_to("asset_id.out", model.uuid)
