#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


tb.initialize(api_token=tb.config.example_user3["token"], example=True)

# Find the dataset we want to work with
dataset = tb.TableAsset.find(
    "EXAMPLE - UMN Student Admissions Data", owned_by=tb.config.example_user2["team_id"]
)

# Find outlier records in the table
outlier_ids = dataset.detect_outlier(
    "id", ["gmat", "gpa", "work_experience", "age", "admitted"], silent=True
)

if outlier_ids is not None:
    print(f"Outliers found: {outlier_ids}")
else:
    print("No outliers found.")
