#!/bin/bash
# Set up environment variables for Multimodal_Cloud_Vision example

# PostgreSQL connection details
export PG_HOST="localhost"
export PG_PORT="5432"
export PG_USER="postgres"
export PG_PASSWORD="your-postgres-password"
export PG_DATABASE_ORG2="covid_multimodal_org2"
export PG_DATABASE_ORG3="covid_multimodal_org3"

# Azure Blob Storage connection details
export AZURE_STORAGE_ACCOUNT="your-storage-account"
export AZURE_STORAGE_KEY="your-storage-key"
export AZURE_CONTAINER_NAME="covid-xrays"

# Run ID for asset uniqueness
export COVID_MULTIMODAL_RUN_ID="001"  # Change this for subsequent runs

echo "Environment variables set for Multimodal_Cloud_Vision example"
echo "Remember to update this file with your actual credentials before running 'source env_setup.sh'"
echo "The PostgreSQL databases should already be populated by our staff"