#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


tb.initialize(api_token=tb.config.example_user1["token"])

# Example of publishing a dataset in a different format from the source data.
# Here the source data contains a textual category of flow species and a
# calculation is performed to convert that into a numeric species identifier.

name = "EXAMPLE - Iris (reclassified)"
desc = """Example of data owner munging.  The Iris database textual species
classifications (species) are converted into numeric (class) values."""

try:
    print(f"Creating '{name}'")
    asset = tb.asset.DatabaseDataset.create(
        connection="postgresql://demouser:=DJdmcAY8xx%tnsfXuhO@104.154.188.123:5432/postgres",
        query="""
        with species as (
                select distinct species
                from iris
            ),
            row_species as (
                select species, row_number() over () as class
                from species
            )

        select sepal_length, sepal_width, petal_length, petal_width, class
        from iris, row_species
        where iris.species = row_species.species;
        """,
        name=name,
        desc=desc,
    )
except tb.TripleblindAssetAlreadyExists:
    print("Asset already exists.")

print("Data is in position.")
