#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


tb.initialize(api_token=tb.config.example_user1["token"])

# Example of publishing a dataset in a different format from the source data.
# Here a only subset of the source data is used, and a simple calculation is
# performed to generate a daily average from each row of data.

name = "EXAMPLE - FORD daily average price"
desc = """Example of data owner munging.  The day_average value for a single
stock (FORD) is computed from a database holding daily high and low values for
many stocks."""

try:
    print(f"Creating '{name}'")
    asset = tb.asset.DatabaseDataset.create(
        connection="postgresql://demouser:=DJdmcAY8xx%tnsfXuhO@104.154.188.123:5432/postgres",
        query="""
        select date, high, low, (high + low) / 2 as day_average
        from stock.daily
        where ticker = 'F'
        order by date;
        """,
        name=name,
        desc=desc,
        # Since 2a_run_report.py wants to display a portion of this data, the
        # columns must be explicitly "unmasked" before they can be displayed.
        unmask_columns=["high", "low", "day_average"],
        is_discoverable=True,
    )
except tb.TripleblindAssetAlreadyExists:
    print("Asset already exists.")
    asset = tb.TableAsset.find(name, owned_by=tb.config.example_user1["team_id"])


print("Data is in position.")
