#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


raise SystemExit("This script is for reference only.")

tb.initialize()

#############################################################################
# Snowflake is a cloud database company.  TripleBlind data assets can be
# created on top of a Snowflake database using an SQL Query to define a view.
# Beyond the view, you also need to define the route to the database as
# well as proper credentials to access the data.


# The account name you use to login to Snowflake.
USERNAME = "steve"

# The password you use to login to Snowflake.
PASSWORD = "A1bCdeFgH234ijK"

# Your account, found at the start of the URL you use to access Snowflake
# on the web.  E.g. "ab98765.us-central1.gcp" if you log in to the URL
# https://ab98765.us-central1.gcp.snowflakecomputing.com/
ACCOUNT = "ab98765.us-central1.gcp"

# The warehouse that will be used to compute/process the query
WAREHOUSE = "TEST_WAREHOUSE"

# The database within your account
DATABASE = "TEST_DATABASE"

# The schema within the database
SCHEMA = "PUBLIC"

# The role of of the user connecting to the Snowflake database.
ROLE = "ACCOUNTADMIN"

# ANSI SQL statement which generates the view of data you want to connect as an
# asset.  This can be simple or complex with conditions and calculated fields.
SQL_VIEW = "SELECT * FROM sant_train LIMIT 500 OFFSET 50;"


# Create an asset that points to a subset of the Snowflake table
asset = tb.asset.SnowflakeDatabase.create(
    snowflake_username=USERNAME,
    snowflake_password=PASSWORD,
    snowflake_account=ACCOUNT,
    snowflake_warehouse=WAREHOUSE,
    snowflake_database=DATABASE,
    snowflake_schema=SCHEMA,
    role=ROLE,
    query=SQL_VIEW,
    name="Demo Database View",
    desc="Dataset housed in a Snowflake data warehouse.",
    is_discoverable=True,
)
