#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


raise SystemExit("This script is for reference only.")

tb.initialize()

#############################################################################
# Redshift is a data warehouse provided by Amazon Web Services.
# TripleBlind data assets can be created on top of this warehouse by defining a
# view of the data using an SQL Query.  Beyond the view, you also need to
# define the route to the data warehouse as well as proper credentials to access
# the data.
#
# The values below define a data asset that is linked to your warehouse.  If
# unsure of any of the below settings, your Redshift admin can view settings at:
# https://console.aws.amazon.com/redshift/


# Address of your Redshift cluster's server
SERVER = "default.528655681674.us-east-2.redshift-serverless.amazonaws.com"

# The default port for Redshift is 5439.  This can be customized, if unsure see:
PORT = 5439

# The specific database name within Redshift
DATABASE_NAME = "dev"

# SQL statement which generates the view of data you want to connect as an
# asset.  This can be simple or complex with conditions and calculated fields.
SQL_VIEW = 'SELECT * FROM public."demo_pii" where n1 > .21;'

#############################################################################
# Option 1: Use database credentials

asset1 = tb.asset.RedshiftDatabase.create(
    host=SERVER,
    port=PORT,
    database=DATABASE_NAME,
    username="dbuser1",
    password="dbpassword1",
    query=SQL_VIEW,
    name="Demo DB 2",
    desc="Redshift Database using credentials",
    is_discoverable=True,
)

#############################################################################
# Option 2: Use IAM access keys for credentials
#
# The options value can hold a dictionary of Redshift connection options.
# There are a large number of combinations of values which might be needed,
# depending on your particular database setup.  The simplest case is illustrated
# below, and all Redshift options are supported as described at:
# https://docs.aws.amazon.com/redshift/latest/mgmt/python-configuration-options.html

asset2 = tb.asset.RedshiftDatabase.create(
    host=SERVER,
    port=PORT,
    database=DATABASE_NAME,
    options={
        "iam": True,
        "access_key_id": "XXXXXXXXXXXXXXXXXXXXXXXXX",
        "secret_access_key": "XXXXXXXXXXXXXXXXXXXXXXXX",
    },
    query=SQL_VIEW,
    name="Demo DB 1",
    desc="Redshift Database using IAM",
    is_discoverable=True,
)
