#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


raise SystemExit("This script is for reference only.")

tb.initialize()

#############################################################################
# BigQuery is a data warehouse offered by Google Cloud.  TripleBlind data assets
# can be created on top of this warehouse by defining a view of the data using
# an SQL Query.  Beyond the view, you also need to define the route to the data
# warehouse as well as proper credentials to access the data.

# A BigQuery dataset exists within a project, so both the project ID and the
# dataset name must be specified.
GCP_PROJECT_ID = "tripleblind-datasets"
DATASET_NAME = "tripleblind_datasets"

# Path to your GCP Credentials file.  For help on obtaining one of these JSON
# files for your BigQuery database see:
# https://developers.google.com/workspace/guides/create-credentials#create_credentials_for_a_service_account
CREDENTIAL_FILE = "bigquery_credentials.json"

# SQL statement which generates the view of data you want to connect as an
# asset.  This ANSI SQL can be simple or complex with conditions and calculated
# fields.
QUERY = "SELECT * FROM `1m_salaries` LIMIT 10"

# Option 1: Create the BigQueryDatabase asset using the credentials file.
asset = tb.asset.BigQueryDatabase.create(
    gcp_project=GCP_PROJECT_ID,
    bigquery_dataset=DATASET_NAME,
    credentials=CREDENTIAL_FILE,
    query=QUERY,
    name="Demo Salaries",
    desc="Dataset of salary information stored in BigQuery",
    is_discoverable=False,
)
