#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


tb.initialize(api_token=tb.config.example_user3["token"], example=True)

table = tb.TableAsset.find(
    "EXAMPLE - NYU Student Admissions Data",
    owned_by=tb.config.example_user1["team_id"],
)

# Retrieve mock data (always the same for this asset)
mock = table.get_mock_data()
print(f"\n\n  Mock data:\n  {'=' * 40}")
print(mock)
mock.to_csv("mock.csv", index=False)

# Retrieve newly generated sample data
sample = table.get_sample(num_samples=5)
print(f"\n\n  Sampled data:\n  {'=' * 40}")
print(sample)
print("\nSaved as sample1.csv")
sample.to_csv("sample1.csv", index=False)

# Retrieve a second sample, which is completely different.
sample = table.get_sample(num_samples=50)
print(f"\n\n  More sampled data:\n  {'=' * 40}")
print(sample)
print("\nSaved as sample2.csv")
sample.to_csv("sample2.csv", index=False)
