#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


# The creation of the summary report is performed by the data owner.  In thisf
# example the first organization is the report owner with a database isolated
# behind their Access Point.
tb.util.set_script_dir_current()
# tb.initialize("87db14ce17d84bbb796157423d372df921481fa8d6bba9b77f5676b54ffe0547", endpoint="https://devkidsights.tripleblind.app")

tb.initialize(tb.config.example_user3["token"])

# This query template defines the information they are willing to share with
# others.  It contains two parameters -- "demographic" and "vitals" -- both of
# which are used twice in the query:
TEMPLATE = """
SELECT AVG(p.Age) AS avg_age FROM SchemaDemo_Appointments a LEFT JOIN SchemaDemo_Patients p ON a.PatientID = p.PatientID
    WHERE {{code}} AND Date > '{{date}}';
"""
NAME = "report test 45"
run_params = {"code": ["3393"], "date": "2024-03-21"}

date_param = tb.report_asset.ReportParameter.create_datetime(
    name="date",
    description="Appointments only after this date",
    display="Appointments only after this date",
    datetime_format="%Y-%m-%d",
    default_value="2024-03-21",
    min_value="1900-01-01",
    max_value="2100-01-01",
)

code_param = tb.report_asset.ReportParameter.create_code(
    name="code",
    display="Appointments only with given ICD code(s)",
    description="Appointments only with given ICD code(s)",
    systems=["ICD-10", "ICD-9"],
    comparison_column="ICDCODE",
)

# An Asset can be published for any organization to see by making it
# "discoverable".  It is also possible to create an Asset that is only
# visible to specific organizations.
PUBLISH_ON_ROUTER = True

# The name of the report asset


report_asset = tb.report_asset.MSSQLReport.create(
    host="kidsightsdemotruesql.database.windows.net",
    port=1433,
    database="kidsightsdemotruesql",
    username="kidsights_ro",
    password="kid$1Gh+5",
    query_template=TEMPLATE,
    params=[date_param, code_param],
    name=NAME + " with ICD codes",
    desc="This report provides the average age of patients with a given diagnosis happening after a specified date.",
    is_discoverable=PUBLISH_ON_ROUTER,
    allow_overwrite=True,
)

report_asset.add_agreement(with_team=2, operation=report_asset.uuid)


tb.initialize(tb.config.example_user2["token"])

r = report_asset.run(params=run_params)

print(r.dataframe)

exit()

print("Creating report withOUT validation")
report_asset = tb.report_asset.MSSQLReport.create(
    host="kidsightsdemotruesql.database.windows.net",
    port=1433,
    database="kidsightsdemotruesql",
    username="kidsightsdemo",
    password="trz.UQU*efy-xja4rdm",
    query_template=TEMPLATE,
    params=[demographic_param, vital_param],
    name=NAME + "_without_validation",
    desc="Sample report from a Azure SQL database of patient vital information with configurable demographics.",
    is_discoverable=PUBLISH_ON_ROUTER,
    validate_sql=False,
)

print("Creating report with validation")
report_asset = tb.report_asset.MSSQLReport.create(
    host="kidsightsdemotruesql.database.windows.net",
    port=1433,
    database="kidsightsdemotruesql",
    username="kidsightsdemo",
    password="trz.UQU*efy-xja4rdm",
    query_template=TEMPLATE,
    params=[demographic_param, vital_param],
    name=NAME + "_with_validation",
    desc="Sample report from a Azure SQL database of patient vital information with configurable demographics.",
    is_discoverable=PUBLISH_ON_ROUTER,
)
