#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import sys

import tripleblind as tb


run_id = tb.util.read_run_id()

# The creation of the summary report is performed by the data owner.  In this
# example the first organization is the data owner.
tb.initialize(api_token=tb.config.example_user1["token"])

# This organization determines the information they are willing to share with
# another organization:
report = """
SELECT * FROM passengers;
"""

# This example is built around a BigQuery database.  You will need to point to
# the credentials that Google provides, as well as your GCP project associated
# with the database, as well as the database name itself.
credentials = tb.util.script_dir() / "credentials.json"
gcp_project_id = "tripleblind-datasets"
bigquery_dataset = "tripleblind_datasets"

# An Asset can be published for any organization to see by making it
# "discoverable".  It is also possible to create an Asset that is only
# visible to specific organizations.
PUBLISH_ON_ROUTER = True

try:
    print("Creating private query...")
    asset = tb.asset.BigQueryDatabase.create(
        gcp_project_id,
        bigquery_dataset,
        credentials,
        query=report,
        name=f"EXAMPLE-Transit System Passengers",
        desc="Sample DatabaseAsset representing a database of transit system usage information, including specifics on passengers",
        is_discoverable=PUBLISH_ON_ROUTER,
    )
except tb.TripleblindAssetAlreadyExists:
    print("Summary report already exists.")
    sys.exit(1)


try:
    asset.add_agreement(with_team="ANY", operation=tb.Operation.REGEX_COUNT)
    print("Added Agreement for operation REGEX with any team.")
except Exception as e:
    print(e)
    print("Error: Could not create the agreement.")


print("Query ID:", asset.uuid)
