#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

from pathlib import Path

import tripleblind as tb


tb.initialize(api_token=tb.config.example_user2["token"])
tb.util.set_script_dir_current()

data_dir = Path("example_data")
asset_name = "EXAMPLE - EHR Notes"

try:
    print("Positioning 'EHR Notes' on organization-two's Access Point...")
    asset_0 = tb.Asset.position(
        file_handle=data_dir / "ehr_notes.csv",
        name=asset_name,
        desc="Notes from a fictional patient's Electronic Health Record",
        is_discoverable=True,
    )

except tb.TripleblindAssetAlreadyExists:
    print(f"Asset '{asset_name}' already exists.'")
    asset_0 = tb.Asset.find(asset_name, owned_by=tb.config.example_user2["team_id"])


print("Data is in position.")
