#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


tb.initialize(api_token=tb.config.example_user2["token"], example=True)

try:
    team_name = tb.config.example_user2["name"]
    print(f"Uploading example dataset to {team_name}'s access point...")

    asset_0 = tb.asset.CSVDataset.create(
        datafile="movie_rating_train.csv",
        name="Movie Rating Data",
        desc="Dataset containing movie rating data which will be used in training BERT sentiment model.",
        is_discoverable=True,
    )
except tb.exceptions.TripleblindAssetAlreadyExists:
    print("An asset named 'Movie Rating Data' already exists.")
    asset_0 = tb.Asset.find(
        "Movie Rating Data", owned_by=tb.config.example_user2["team_id"]
    )


if tb.config.create_agreements_on_example_input_assets:
    asset_0.add_agreement(
        with_team=tb.config.example_user1["team_id"],
        operation=tb.Operation.BERT_SEQ_CLF_TRAIN,
    )
    print(f"  Created access Agreement with '{tb.config.example_user1['name']}'")


print("Data is in position.")
