#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


tb.initialize(tb.config.example_user2["token"])

# Credentials for an Oracle demo database
host = "tripleblind-ps.cruqs3hjb8c8.us-east-1.rds.amazonaws.com"
port = 1521
database = "TB"
username = "ro_user"
password = "Blinded#By.TheLIGHT!"
# NOTE: You should not hard-code a password for several reasons:
# - It can be viewed by other users on your team with Asset Retrieve permissions
# - The password cannot be changed later
#
# You should reference a secret stored on your Access Point using the CLI tool
#   tbadmin secrets set my_password "Blinded#By.TheLIGHT!"
# with a reference to the secret name, like this:
#  password = "{{my_password}}"


# Create the standard Patient view (see the README.txt for details)
#
# Note some fields must be aliased to match the standard view.
q1 = """
SELECT
    p.PatientID AS PatientID,
    p.BirthDate AS PatientDOB,
    p.AddressCity AS City,
    p.AddressState AS State,
    p.AddressCode AS PostalCode,
    p.Gender AS Sex
FROM MASTEROFCLOUDS18.demoPatient p
"""

source2_patient = tb.asset.OracleDatabase.create(
    host=host,
    port=port,
    database=database,
    username=username,
    password=password,
    name="DEMO - Hospital Data Federation, Patient DB 2",
    desc="""Standard view of the Patient database for General Prophecy Hospital,
      backed by an Oracle database. This is part of the Hospital Data
      Federation demo.""",
    is_discoverable=True,
    allow_overwrite=True,
    query=q1,
)

# Create the standard Billed Visit view
#
# Note the NetCharges field must be calculated to produce the standard view.
q2 = """
SELECT
    bv.PatientID AS PatientID,
    bv.AdmitDate AS AdmitDate,
    bv.ReleaseDate AS DischargeDate,
    bv.VisitType AS VisitType,
    bv.DiagnosisCode AS BillingCode,
    bv.ProcedureCode AS ProcedureCode,
    (bv.CostToPatient + bv.CostToHospital) AS NetCharges
FROM MASTEROFCLOUDS18.demoBilledVisit bv
"""

source2_billedvisit = tb.asset.OracleDatabase.create(
    host=host,
    port=port,
    database=database,
    username=username,
    password=password,
    name="DEMO - Hospital Data Federation, Billed Visit DB 2",
    desc="""Standard view of the Billed Visit database for General Prophecy
      Hospital, backed by an Oracle database. This is part of the Hospital Data
      Federation demo.""",
    is_discoverable=True,
    allow_overwrite=True,
    query=q2,
)
