#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.
import tripleblind as tb


DATA_OWNER = tb.config.example_user1
CONSUMER = tb.config.example_user2


session = tb.initialize(api_token=DATA_OWNER["token"])
jobs = tb.job.Job.find_all(job_name="Example Continuous Inference")

if jobs is None or len(jobs) == 0:
    raise SystemError("Inference is not running.")

for job in jobs:
    print(f"Killing {job.job_name=}...")
    try:
        if job.kill():
            print(f"Successfully killed job: {job.job_name}")
        else:
            print(
                f"Failed to kill job: {job.job_name}, may have previously been killed."
            )
    except Exception as e:
        print(f"Exception received trying to kill {job.job_name}: {e}")
