library(ISLR)
library(pmml)
set.seed(123)

attach(Default)
sample <- sample(c(TRUE, FALSE), nrow(Default), replace = T, prob = c(0.6,0.4))
train <- Default[sample, ]
test <- Default[!sample, ]
df_validate <- rbind(Default[1:5,], Default[Default$default == "Yes",][1:5,])

model1 <- glm("default ~ student + balance + income", family="binomial", data=train)

p <- predict(model1, newdata=df_validate, type="response")
cat(p, sep="\n")
write.csv(data.frame(expected=p), paste("default-glm", ".csv", sep=""), row.names=FALSE)

model_pmml <- pmml(model1)
write(toString(model_pmml), file=paste("default-glm", ".xml", sep=""))
