#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

from pathlib import Path

import tripleblind as tb


tb.util.set_script_dir_current()
data_dir = Path("example_data")

run_id = tb.util.read_run_id()

tb.initialize(api_token=tb.config.example_user1["token"])

try:
    print("Uploading HIPAA Restricted A to organization one's access point...")
    asset_0 = tb.Asset.position(
        file_handle=data_dir / "hipaa_restricted_a.csv",
        name=f"hipaa_restricted_a-{run_id}",
        desc="Data that is ill-formatted.",
        is_discoverable=True,
    )
except tb.TripleblindAssetAlreadyExists:
    print(
        "HIPAA Restricted A already exists, change value in run_id.txt to make it unique."
    )

session_org_3 = tb.Session(
    api_token=tb.config.example_user3["token"], from_default=True
)

try:
    print("Uploading HIPAA Restricted B to organization two's access point...")
    asset_1 = tb.Asset.position(
        file_handle=data_dir / "hipaa_restricted_b.csv",
        name=f"hipaa_restricted_b-{run_id}",
        desc="Data that is ill-formatted.",
        is_discoverable=True,
        session=session_org_3,
    )

    if tb.config.create_agreements_on_example_input_assets:
        # For this example we will attach an Agreement to the datasets.  This
        # agreement makes the dataset available to the other team.
        asset_0.add_agreement(
            with_team=tb.config.example_user3["team_id"],
            operation=tb.Operation.BLIND_QUERY,
        )
        asset_1.add_agreement(
            with_team=tb.config.example_user1["team_id"],
            operation=tb.Operation.BLIND_QUERY,
            session=session_org_3,
        )
        print("Created agreement")
except tb.TripleblindAssetAlreadyExists:
    print(
        "HIPAA Restricted B already exists, change value in run_id.txt to make it unique."
    )

print("Data is in position.")
