#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


# raise SystemExit("This script is for reference only.")

tb.initialize()

#############################################################################
# MongoDB is a document-oriented "NoSQL" database. A TripleBlind data asset
# can be created from a view generated by MongoDB. Beyond the view, you need
# to define the address of the server and provide credentials to access it.

# Credentials to the database (read-only credentials are recommended)
user = "dbuser"
password = "dbpassword"


# TripleBlind supports multiple MongoDB connection URI formats.  Any of the
# following connection string styles can be used:

# Single Database Instance:
mongo_host = "mongo.host.com"
mongo_port = 27017
CONNECTION_STR1 = f"mongodb://{user}:{password}@{mongo_host}:{mongo_port}/"

# DNS Seed List:
# The host represents a DNS SRV record which is queried to retrieve the sharded endpoints.
CONNECTION_STR2 = (
    f"mongodb+srv://{user}:{password}@cluster0.rwgkyrs.mongodb.net/?ssl=true&w=majority"
)

# Sharded Cluster (Pre MongoDB 3.6 style):
# Each shard is separated by a comma in the connection string.
CONNECTION_STR3 = (
    f"mongodb://{user}:{password}@ac-x4d61sp-shard-00-00.rwgkyrs.mongodb.net:27017,"
    + "ac-x4d61sp-shard-00-01.rwgkyrs.mongodb.net:27017,"
    + "ac-x4d61sp-shard-00-02.rwgkyrs.mongodb.net:27017/"
    + "?ssl=true&replicaSet=atlas-fvumfd-shard-0&authSource=admin&w=majority"
)


# The query is what instructs MongoDB how to assemble the data view provided
# to this asset.  This view can be simple or complex, joining many different
# Mongo documents.
#
# Here we will give an empty query, which simply retrieves all records
QUERY = {}
# A Mongo projection defines the fields to report from the records
PROJECTION = {
    "gmat": 1,
    "gpa": 1,
    "work_experience": 1,
    "age": 1,
    "admitted": 1,
    "_id": 0,
}

asset = tb.asset.MongoDatabase.create(
    connection_str=CONNECTION_STR1,
    query=QUERY,
    projection=PROJECTION,
    name="Demo College Acceptance",
    desc="College acceptance dataset from a MongoDB database.",
    is_discoverable=True,
    database="datasets",
    collection="college_acceptance",
)
