# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.
# See the file LICENSE in a parent directory for the full license and terms
raise SystemExit("This script is for reference only.")

import tripleblind as tb


tb.initialize(tb.config.example_user2["token"])

mssql_database_datasource = tb.database_datasource.MSSQLDatabaseDatasource.create(
    host="my-mssqldbhost.database.windows.net",
    port=1433,
    database="my_mssql_db",
    username="user1",
    password="some_password!",
    name="My MSSQL Database Datasource",
    desc="A database connection to a MSSQL Database",
    is_discoverable=True,
    allow_overwrite=True,
)

mssql_database_datasource.add_agreement(
    with_team=tb.config.example_user1["team_id"],
    operation=tb.Operation.SCHEMA_RETRIEVAL,
)

mssql_asset_id = mssql_database_datasource.uuid

tb.initialize(tb.config.example_user1["token"])

db_connection = tb.database_datasource.DatabaseDatasourceAsset.find(mssql_asset_id)
if db_connection:
    schema_result = db_connection.retrieve_schema(
        params={},
    )
    if schema_result:
        schema_result.asset.download(save_as="schema_result.zip", overwrite=True)

else:
    print("Failed to create database connection")
