#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


# In this example the retailer is running report and the transit company
# will be asked for permission to access their data.
tb.initialize(api_token=tb.config.example_user1["token"], example=True)

trips = tb.TableAsset.find(
    "EXAMPLE - Transport Data", owned_by=tb.config.example_user2["team_id"]
)
purchases = tb.TableAsset.find(
    "EXAMPLE - Shop Transactions", owned_by=tb.config.example_user1["team_id"]
)

# Perform an "inner" join.  Only the overlapped records from the datasets are
# combined and reported.
inner = purchases.blind_join(
    intersect_with=trips,
    match_column=["address", "customer_address"],
    return_columns=[
        [
            "price",
            "name",
        ],
        ["depart_station", "arrive_station"],
    ],
    silent=False,
    join_type=tb.JoinType.INNER,
)

if inner:
    print()
    if inner.dataframe.empty:
        print("Blind Join returned no intersecting records.")
    else:
        print("  Inner Join:")
        print(inner.dataframe)

    inner.retrieve("join_inner.zip", overwrite=True)
    print("Results saved as 'join_inner.zip'")
else:
    print("Failed to return result.")
