#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


# report is owned by org3
tb.initialize(tb.config.example_user1["token"])

report = tb.report_asset.DatabaseReport.find(
    "[DEMO] Readmission Rate Report (Federated Report)"
)
output = report.run(
    {
        "demographic": "pv.Sex",
        "date": "2022-02-02",
        "ICDcode": [
            "J42",
            "J204",
            "J410",
            "J205",
            "J44.9",
            "J40",
            "J411",
            "J202",
            "J203",
        ],
        "PCScode": [
            "0BH64ZZ",
            "0BQ34ZZ",
            "3E0234Z",
            "5A09357",
            "3E0333Z",
            "5A1935Z",
            "0W9N0ZZ",
            "3E0333Z",
        ],
    },
    # can remove any to run with fewer members
    federation_member_names=[
        "Blue Sky Memorial Hospital",
        "General Prophecy Hospital",
        "Harmony Research Hospital",
    ],
)

# Retrieve the output as a Pandas dataframe
output.load(header=True)  # force the first line to be read as column names
print("\n\nReport output as a dataframe:")
print(output.dataframe)

# Retrieve the output as raw text
print("\n\nRaw report output:")
print(output.raw_content)

output.retrieve(save_as="res.zip", overwrite=True)

# Render the report manifest in browser
output.render_manifest()
