#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


# The Aggregator team will define the Federation Group
tb.initialize(tb.config.example_user3["token"])

# Each Data Provider has communicated with the Aggregator to provide information
# about this assets implementing the standard views.  The scripts below locate
# these assets by name for clarity and simplicity, but an Asset ID could be
# communicated and used instead.
member_1 = tb.FederationMember.create(
    name="Blue Sky Memorial Hospital",
    display="Blue Sky Memorial Hospital",
    desc="Data Provider running on Azure databases",
    assets={
        "Patient": tb.Asset.find(
            "DEMO - Hospital Data Federation, Patient DB 1", owned_by=1
        ),
        "BilledVisit": tb.Asset.find(
            "DEMO - Hospital Data Federation, Billed Visit DB 1", owned_by=1
        ),
    },
)

member_2 = tb.FederationMember.create(
    name="General Prophecy Hospital",
    display="General Prophecy Hospital",
    desc="Data Provider running on Oracle databases",
    assets={
        "Patient": tb.Asset.find(
            "DEMO - Hospital Data Federation, Patient DB 2", owned_by=2
        ),
        "BilledVisit": tb.Asset.find(
            "DEMO - Hospital Data Federation, Billed Visit DB 2", owned_by=2
        ),
    },
)

member_3 = tb.FederationMember.create(
    name="Harmony Research Hospital",
    display="Harmony Research Hospital",
    desc="Data Provider running on Postgres databases and Federation Aggregator",
    assets={
        "Patient": tb.Asset.find(
            "DEMO - Hospital Data Federation, Patient DB 3", owned_by=3
        ),
        "BilledVisit": tb.Asset.find(
            "DEMO - Hospital Data Federation, Billed Visit DB 3", owned_by=3
        ),
    },
)

# Define the Federation Group.
tb.FederationGroup.create(
    "[DEMO] Harmony Data Federation",
    members=[member_1, member_2, member_3],
)
# NOTE: This named group can be redefined later by editing this script and
# running it again. This makes it easy to add more data providers to enhance
# the data cohort. Existing federated reports will automatically include the
# most recent list of federation members when they are used.
