#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import random
import time

import pymongo


# Credentials to connect to a single MongoDB server database
# (read-only credentials recommended)
user = "dbuser"
password = "dbpassword"
mongo_port = 27017
CONNECTION_STR1 = f"mongodb://localhost:27017/"
client = pymongo.MongoClient(CONNECTION_STR1)
db = client["test_db"]
coll = db["energy_data"]


# Run a continuous loop simulating real-time energy usage data.  Every second,
# a new timestamped data point is generated and added to the database.  The view
# being used by the continuous inference will pick up the latest 30 seconds of
# data in order to perform the next inference.
while True:
    var = random.randint(0, 1000)
    ts = time.time()
    coll.insert_one({"Timestamp": ts, "P": var})
    print("Inserted", var, "time:", ts)

    time.sleep(1)
