#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


DATA_OWNER = tb.config.example_user1
CONSUMER = tb.config.example_user2

tb.initialize(api_token=DATA_OWNER["token"], example=True)


# Configure IP address to MongoDB host machine
MongoDB_IP = "192.168.193.251"

#############################################################################
# MongoDB is a document-oriented "NoSQL" database. A TripleBlind data asset
# can be created from a view generated by MongoDB. Beyond the view, you need
# to define the address of the server and provide credentials to access it.

# Single Database Instance:
mongo_host = "mongo.host.com"
mongo_port = 27017
CONNECTION_STR1 = f"mongodb://{MongoDB_IP}:27017/datasets"

QUERY = {}

# A Mongo projection defines the fields to report from the records
PROJECTION = {"P": 1, "Timestamp": 1}


# Configure with proper DB params
asset = tb.asset.MongoDatabase.create(
    connection_str=CONNECTION_STR1,
    query=QUERY,
    projection=PROJECTION,
    name="Energy forecast live data",
    desc="View of the last 30-seconds of power usage.",
    is_discoverable=True,
    database="test_db",
    collection="energy_data",
    limit=30,
    sort=[["Timestamp", -1]],
)
