#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import re
import sys

import tripleblind as tb


run_id = tb.util.read_run_id()
tb.util.set_script_dir_current()
tb.initialize(api_token=tb.config.example_user2["token"])


# Find the dataset to search in the Router's index
table = tb.TableAsset.find(
    f"People-{run_id}", owned_by=tb.config.example_user1["team_id"]
)
if not table:
    raise SystemError(
        f"ERROR: People data not found. Run 1_position_data_on_access_point.py"
    )


# Look for single string (defaults to case sensitive)
result = table.search("full_name", pattern="Doe", silent=True)
print("\nMatches:")
result.print_content(show_rows=True)


# Look for several search strings, simple and RegEx strings
result = table.search(
    "full_name",
    pattern=["Doe", re.compile("(Doe|Dough)"), "dr."],
    match_case=False,
    silent=True,
)
print("Matches:")
result.print_content(show_rows=True)
