#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

from pathlib import Path

import tripleblind as tb


tb.util.set_script_dir_current()
run_id = tb.util.read_run_id()

tb.initialize(api_token=tb.config.example_user1["token"])

# Loading the CSV
tb.util.set_script_dir_current()
data_dir = Path("example_data")
train_data = tb.util.download_tripleblind_resource(
    "people.csv",
    save_to_dir=data_dir,
    cache_dir="../../.cache",
)

try:
    print(f"Positioning 'people.csv' on {tb.config.example_user1['login']}...")
    asset = tb.asset.CSVDataset.position(
        file_handle=train_data,
        name=f"People-{run_id}",
        desc="Some people that have traits",
        is_discoverable=True,
        auto_rename_columns=True,
    )

    if tb.config.create_agreements_on_example_input_assets:
        # For this example we will attach an Agreement to the datasets.  This
        # agreement makes the dataset available to the other team, which
        # means the search operation will not require the dataset owner to
        # explicitly grant permission when it is used in the next step.
        asset.add_agreement(
            with_team=tb.config.example_user2["team_id"],
            operation=tb.Operation.REGEX_COUNT,
        )
        print("Created Agreement")
except tb.TripleblindAssetAlreadyExists:
    print(
        f"Asset 'People-{run_id}' already exists, change value in run_id.txt to make it unique."
    )


print("Data is in position.")
