#!/usr/bin/env Rscript
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

# Install required packages if not already installed
RequiredPackages <- c("reticulate")
for (i in RequiredPackages) { #Installs packages if not yet installed
    if (!require(i, character.only = TRUE)) install.packages(i)
}


# Load packages
library(reticulate)

tb <- import("tripleblind")

tb$initialize(api_token = tb$config$example_user1[["token"]])
tb$util$set_script_dir_current()
run_id <- tb$util$read_run_id()


asset <- tb$TableAsset$find(paste("Blind_Sample-", run_id, sep = ""))
if (identical(NULL, asset)) {
  print(paste("ERROR: Blind_Sample-", run_id, " dataset not found.", sep = ""))
  print("Must run 1_position_data_on_accesspoint.py first.")
  quit(save = "ask")
}

df <- asset$get_sample()
print(df)
write.csv(df, "sample.csv", row.names = TRUE)
