#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


raise SystemExit("This script is for reference only.")

# The creation of the summary report is performed by the data owner.  In this
# example the first team is the data owner.
tb.initialize(api_token=tb.config.example_user1["token"])

# This team determines the information they are willing to share with
# another team:
report = """
SELECT Ethnicity, count(*) as Samples, avg(Total_Gross) as Average_Gross,
FROM `your-gcpproject.your_datasets.payroll`
GROUP BY Ethnicity HAVING Samples >= 5
ORDER BY Ethnicity
"""

# This example is built around a BigQuery database.  You will need to point to
# the credentials that Google provides, as well as your GCP project associated
# with the database, as well as the database name itself.
credentials = tb.util.script_dir() / "credentials.json"
gcp_project_id = "your-gcpproject"
bigquery_dataset = "your_datasets"

# An Asset can be published for any team to see by making it
# "discoverable".  It is also possible to create an Asset that is only
# visible to specific teams.
PUBLISH_ON_ROUTER = False

try:
    print("Creating private query...")
    asset = tb.asset.BigQueryDatabase.create(
        gcp_project_id,
        bigquery_dataset,
        credentials,
        query=report,
        name="Company Payroll Diversity Report by Ethnicity",
        desc="Summary of payroll by ethnicity categories",
        is_discoverable=PUBLISH_ON_ROUTER,
    )
except tb.TripleblindAssetAlreadyExists:
    raise SystemExit("Summary report already exists.")

if not PUBLISH_ON_ROUTER:
    # If you wish to share the private query without listing it, you can
    # privately publish the Asset to a specific team. The other
    # team will be able to see it, but will still require explicit
    # permission to use it.
    asset.publish_to_team(tb.config.example_user2["team_id"])
    print(f"Published only for '{tb.config.example_user2['name']}'")

print("Query ID:", asset.uuid)
