#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

from pathlib import Path

import tripleblind as tb


tb.util.set_script_dir_current()
data_dir = Path("example_data")

run_id = tb.util.read_run_id()

tb.initialize(api_token=tb.config.example_user1["token"])

try:
    print("Uploading 'santander 0-40' to organization-one's Access Point...")
    asset_0 = tb.Asset.position(
        data_dir / "sant_psi_vertical_0_40_train.csv",
        name=f"sant psi vertical 0-40-{run_id}",
        desc="Santander data 0-40.",
        is_discoverable=True,
    )
except tb.TripleblindAssetAlreadyExists:
    print(
        f"Asset 'sant psi vertical 0-40-{run_id}' already exists, change value in run_id.txt to make it unique.'"
    )


session_org_2 = tb.Session(
    api_token=tb.config.example_user2["token"], from_default=True
)

try:
    print("Uploading 'santander 41-100' to organization-two's Access Point...")
    asset_1 = tb.Asset.position(
        data_dir / "sant_psi_vertical_41_100_train.csv",
        name=f"sant psi vertical 41-100-{run_id}",
        desc="Santander data 41-100.",
        is_discoverable=True,
        session=session_org_2,
    )

    if tb.config.create_agreements_on_example_input_assets:
        # For this example we will attach an Agreement to the datasets.  This
        # agreement makes the dataset available to the other team,
        # meaning the training step will not require the dataset owner to
        # explicitly grant permission for use.
        asset_1.add_agreement(
            with_team=tb.config.example_user1["team_id"],
            operation=tb.Operation.PSI_VERTICAL_BLIND_LEARNING,
            session=session_org_2,
        )
        print("Created Agreement")
except tb.TripleblindAssetAlreadyExists:
    print(
        f"Asset 'sant psi vertical 41-100-{run_id}' already exists, change value in run_id.txt to make it unique.'"
    )


session_org_3 = tb.Session(
    api_token=tb.config.example_user3["token"], from_default=True
)

try:
    print("Uploading 'santander 101-200' to organization-three's Access Point...")
    asset_2 = tb.Asset.position(
        data_dir / "sant_psi_vertical_101_200_train.csv",
        name=f"sant psi vertical 101-200-{run_id}",
        desc="Santander data 101-200.",
        is_discoverable=True,
        session=session_org_3,
    )

    if tb.config.create_agreements_on_example_input_assets:
        asset_2.add_agreement(
            with_team=tb.config.example_user1["team_id"],
            operation=tb.Operation.PSI_VERTICAL_BLIND_LEARNING,
            session=session_org_3,
        )
        print("Created Agreement")
except tb.TripleblindAssetAlreadyExists:
    print(
        f"Asset 'sant psi vertical 101-200-{run_id}' already exists, change value in run_id.txt to make it unique.'"
    )

print("Data is in position.")
