#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import sys

import tripleblind as tb


tb.util.set_script_dir_current()
# tb.initialize(api_token=tb.config.example_user1["token"])
tb.initialize(api_token=tb.config.example_user3["token"])

run_id = tb.util.read_run_id()

bank1 = tb.TableAsset.find(
    f"JPM Customers-{run_id}", owned_by=tb.config.example_user1["team_id"]
)
bank2 = tb.TableAsset.find(
    f"PNB Customers-{run_id}", owned_by=tb.config.example_user2["team_id"]
)
broker = tb.TableAsset.find(
    f"Broker licenses-{run_id}", owned_by=tb.config.example_user3["team_id"]
)
if not bank1 or not bank2 or not broker:
    print("Datasets not found.")
    print("You must run 1_position_data_on_accesspoint.py first")
    sys.exit(1)


overlap = broker.intersect(
    intersect_with=[bank1, bank2], match_column="ssn", silent=True
)
if overlap:
    print(f"Overlap Asset ID: {overlap.uuid}")
    print()
    print("Overlap values saved to file:")
    print("    ", overlap.retrieve(save_as="out.zip", overwrite=True))
else:
    print(f"Overlap failed")
    sys.exit(1)
