#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import sys

import tripleblind as tb


tb.util.set_script_dir_current()
tb.initialize(api_token=tb.config.example_user3["token"])

# Use the model Asset ID from a previous run of 1_position_model.py
try:
    model = tb.Asset(tb.util.load_from("asset_id.out"))
except:
    print("You must run 1_position_model.py first.")
    sys.exit(1)

job = tb.create_job(
    job_name="PMML inference - loan default",
    operation=model,
    dataset="loan_info.csv",
    params={"security": "smpc", "output": "probabilities"},
    preprocessor=tb.TabularPreprocessor.builder().all_columns(True),
)

if job.submit():
    job.wait_for_completion()

    if job.success:
        # Save for later examination
        filename = job.result.table.retrieve(save_as="result.zip", overwrite=True)

        job.result.table.dataframe.columns = ["Probability of loan default"]
        print()
        print(job.result.table.dataframe)
    else:
        print(f"SMPC Inference failed")
