import numpy as np
import pickle


def one_hot_encode(sequence, dict_size, seq_len, batch_size):
    # Creating a multi-dimensional array of zeros with the desired output shape
    features = np.zeros((batch_size, seq_len, dict_size), dtype=np.float32)

    # Replacing the 0 at the relevant character index with a 1 to represent that character
    for i in range(batch_size):
        for u in range(seq_len):
            features[i, u, sequence[i][u]] = 1
    return features


def convert_data_for_inference(character, index_file):
    with open(index_file, "rb") as f:
        indices = pickle.load(f)

    char_to_integer_lookup = indices["char_to_integer_lookup"]
    character = np.array([[char_to_integer_lookup[c] for c in character]])
    character = one_hot_encode(
        character, len(char_to_integer_lookup), character.shape[1], 1
    )
    return character


def convert_int_to_char(index, index_file):
    with open(index_file, "rb") as f:
        indices = pickle.load(f)

    return indices["integer_to_char_lookup"][index]
