#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


tb.initialize(api_token=tb.config.example_user1["token"], example=True)

report_a = tb.Asset.find(
    "EXAMPLE - FORD daily average price", owned_by=tb.config.example_user1["team_id"]
)
if not report_a:
    raise SystemExit(
        "'EXAMPLE - FORD daily average price' dataset not found. You must run 1a_position_with_calculated_field first."
    )

csv_pre = (
    tb.TabularPreprocessor.builder()
    .add_column("high")
    .add_column("low")
    .add_column("day_average")
)

# "Run" the SQL report that underpins the asset, but retrieve only the requested
# columns.  Requesting the first column would fail since it hasn't been unmasked
# by the owner.
job = tb.create_job(
    job_name="Report FORD daily average",
    preprocessor=csv_pre,
    operation=tb.Operation.BLIND_QUERY,
    dataset=report_a,
)

if job.submit():
    job.wait_for_completion()

    if job.success:
        # Print the output of the report
        print(job.result.dataframe)
        job.result.table.dataframe.to_csv("report.out")
    else:
        raise SystemExit("Blind Query failed.")
