#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


raise SystemExit("This script is for reference only.")

tb.initialize()

#############################################################################
# Elasticsearch is a document-oriented "NoSQL" database. A TripleBlind data Asset
# can be created from an Elasticsearch query. It will be coerced into a dataframe
# by flattening the results returned in response["hits"]["hits"].
# Currently, only access via an API token is supported.

# Credentials to the database (read-only credentials are recommended)
API_TOKEN = "token123=="
# Port and index must be specified
HOST = "https://elasticsearch.instance.com:9200"
INDEX = "data123"

# The Elasticsearch query will return the documents that will form the Asset.
# This query can be as simple or complex as you wish. TripleBlind will ship
# the query to the Elastic instance at job initiation and use its live results.
# The query must be in the form of a valid-json python dictionary or string.

# If you wish to use "aggregations" instead of "hits", refer to ElasticsearchReport.

body = {
    "size": 0,
    "query": {
        "bool": {
            "must": [],
            "filter": [
                {
                    "bool": {
                        "minimum_should_match": 1,
                        "should": [
                            {"match_phrase": {"field_1": "value_1"}},
                            {"match_phrase": {"field_2": "value_2"}},
                        ],
                    }
                },
                {
                    "range": {
                        "messageTime": {
                            "format": "strict_date_optional_time",
                            "gte": "2014-01-01",
                            "lte": "2025-01-01",
                        }
                    }
                },
            ],
            "should": [],
            "must_not": [],
        }
    },
    "runtime_mappings": {},
    "timeout": "60000ms",
}

# Create TripleBlind Asset
tb.asset.ElasticsearchDataset.create(
    connection=HOST,
    api_key=API_TOKEN,
    index=INDEX,
    body=body,
    name="Elastic Asset 123",
    desc="A TripleBlind Asset backed by an Elasticsearch database",
    is_discoverable=True,
    allow_overwrite=True,
)
