#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


tb.initialize(api_token=tb.config.example_user2["token"], example=True)

report = tb.ReportAsset.find("EXAMPLE - Payroll Report")

output = report.run(
    {"demographic": "Gender", "trt_code": ["0BQ34ZZ", "3E0234Z", "5A09357"]}
)
# Note that the optional parameter "pay" wasn't specified, so the default of
# "Total_Gross" is used to produce this report.

# Retrieve the output as a Pandas dataframe
output.load(header=True)  # force the first line to be read as column names
print("\n\nReport output as a dataframe:")
print(output.dataframe)

# Retrieve the output as raw text
print("\n\nRaw report output:")
print(output.raw_content)
