#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


# In this example the retailer is running report and the transit company
# will be asked for permission to access their data.
tb.initialize(api_token=tb.config.example_user1["token"], example=True)

trips = tb.TableAsset.find(
    "EXAMPLE - Transport Data", owned_by=tb.config.example_user2["team_id"]
)
purchases = tb.TableAsset.find(
    "EXAMPLE - Shop Transactions", owned_by=tb.config.example_user1["team_id"]
)

# Perform a "left" join.  All the results from your dataset are reported, with
# information from the other dataset augmenting it if found.  Non-matching
# rows have blanks in the "depart_station" and "arrive_station" fields.
res = purchases.blind_join(
    intersect_with=trips,
    match_column=["address", "customer_address"],
    return_columns=[
        [
            "price",
            "name",
        ],
        ["depart_station", "arrive_station"],
    ],
    silent=False,
    join_type=tb.JoinType.LEFT,
)

if res:
    print()
    if res.dataframe.empty:
        print("Blind Join returned no intersecting records.")
    else:
        print("  Left Join:")
        print(res.dataframe)

    res.retrieve("join_left.zip", overwrite=True)
    print("Results saved as 'join_left.zip'")
else:
    print("Failed to return result.")
