#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

from pathlib import Path

import tripleblind as tb


data_dir = Path("example_data")
tb.initialize(api_token=tb.config.example_user1["token"], example=True)

name1 = "EXAMPLE - Shop Transactions"
desc1 = "Fictional retail transaction data."
name2 = "EXAMPLE - Transport Data"
desc2 = "Fictional passenger transport data"

try:
    print(
        f"Uploading '{name1}' to {tb.config.example_user1['login']}'s Access Point..."
    )
    asset_0 = tb.Asset.position(
        file_handle=data_dir / "store_transactions.csv",
        name=name1,
        desc=desc1,
        is_discoverable=True,
        k_grouping=1,
    )
except tb.TripleblindAssetAlreadyExists:
    print(f"Asset '{name1}' already exists, skipping.'")


session_org_2 = tb.Session(
    api_token=tb.config.example_user2["token"], from_default=True
)

# The default way of running this example uses a simple table asset
try:
    print(
        f"Uploading '{name2}' to {tb.config.example_user2['login']}'s Access Point..."
    )
    asset_1 = tb.TableAsset.position(
        file_handle=data_dir / "passengers.csv",
        name=name2,
        desc=desc2,
        is_discoverable=True,
        session=session_org_2,
    )
except tb.TripleblindAssetAlreadyExists:
    print(f"Asset '{name2}' already exists, skipping.'")
    asset_1 = tb.TableAsset.find(name2, owned_by=tb.config.example_user2["team_id"])

# Unmask the arrive and depart station columns
asset_1.unmask_columns(
    col_names=["arrive_station", "depart_station"],
    session=session_org_2,
)
# Create agreement for Blind_Join examples
asset_1.add_agreement(
    with_team=tb.config.example_user1["team_id"],
    operation=tb.Operation.BLIND_JOIN,
    session=session_org_2,
)

print("Data is in position.")
