#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.
from pathlib import Path

import tripleblind as tb


name0 = "EXAMPLE - Basic Statistics (part 2)"
name1 = "EXAMPLE - Basic Statistics (part 3)"
name2 = "EXAMPLE - Basic Statistics (part 1)"
desc = "Simple floating point and gender (M/F) data for Statistics example"


tb.util.set_script_dir_current()
data_dir = Path("example_data")
tb.initialize(api_token=tb.config.example_user1["token"])

# Register the first database with the Router and place on Access Point
try:
    # Start a connection as 'organization_two' user
    session2 = tb.Session(api_token=tb.config.example_user2["token"], from_default=True)

    print(f"Creating '{name0}' on {tb.config.example_user2['login']}'s Access Point...")
    dataset0 = tb.Asset.position(
        file_handle=data_dir / "dataset0.csv",
        name=name0,
        desc=desc,
        is_discoverable=True,
        k_grouping=3,  # force a smaller k-grouping than the default of 5
        session=session2,
    )
    if tb.config.create_agreements_on_example_input_assets:
        # Give user3 access to this file for the STATS calculation
        dataset0.add_agreement(
            with_team=tb.config.example_user3["team_id"],
            operation=tb.Operation.STATS,
            session=session2,
        )
        print("Created Agreement")

except tb.TripleblindAssetAlreadyExists:
    print(f"Asset '{name0}' already exists, skipping.")


# Register the second dataset with the Router and place on Access Point
try:
    # Start a connection as 'organization_three' user
    session3 = tb.Session(api_token=tb.config.example_user3["token"], from_default=True)

    print(f"Creating '{name1}' on {tb.config.example_user3['login']}'s Access Point...")
    dataset1 = tb.Asset.position(
        file_handle=data_dir / "dataset1.csv",
        name=name1,
        desc=desc,
        is_discoverable=True,
        session=session3,
    )
except tb.TripleblindAssetAlreadyExists:
    print(f"Asset '{name1}' already exists, skipping.")


try:
    # Start a connection as 'organization_one' user
    session1 = tb.Session(api_token=tb.config.example_user1["token"], from_default=True)

    print(f"Creating '{name2}' on {tb.config.example_user1['login']}'s Access Point...")
    dataset2 = tb.Asset.position(
        file_handle=data_dir / "dataset2.csv",
        name=name2,
        desc=desc,
        is_discoverable=True,
        k_grouping=3,  # force a smaller k-grouping than the default of 5
        session=session1,
    )
    if tb.config.create_agreements_on_example_input_assets:
        # Give user3 access to this file for the STATS calculation
        dataset2.add_agreement(
            with_team=tb.config.example_user3["team_id"],
            operation=tb.Operation.STATS,
            session=session1,
        )
        print("Created Agreement")

except tb.TripleblindAssetAlreadyExists:
    print(f"Asset '{name2}' already exists, skipping.")

print("Data is in position.")
