#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import os

import tripleblind as tb


userA = tb.config.example_user3  # user who making queries for individuals
userB = tb.config.example_user2  # user who owns a large dataset

if "TB_TEST_SMALL" in os.environ:
    data2 = f"database_test.csv"
    name2 = "TEST - Private Record Linkage"
    desc2 = """
    Testing data for a private record linkage between two organizations.
    This dataset contains 100 individual data records.
    """
else:
    data2 = f"database.csv"
    name2 = "EXAMPLE - Private Record Linkage"
    desc2 = """
    Demonstration data for a private record linkage between two organizations.
    This dataset contains 5000 individual data records.
    """


tb.util.set_script_dir_current()
tb.initialize(api_token=userA["token"])


try:
    # Start a connection as 'organization_two' user
    session2 = tb.Session(api_token=userB["token"], from_default=True)

    print(f"Creating dataset '{name2}' on {userB['login']}'s Access Point...")
    asset2 = tb.Asset.position(
        file_handle=data2,
        name=name2,
        desc=desc2,
        is_discoverable=True,
        session=session2,
    )
except tb.TripleblindAssetAlreadyExists:
    print(f"Asset '{name2}' already exists.'")
    asset2 = tb.Asset.find(name2, owned_by=userB["team_id"], session=session2)

# For this example we will attach an Agreement to the datasets.  This
# agreement makes the dataset available to the other organization,
# meaning the training step will not require the dataset owner to
# explicitly grant permission for use.
asset2.add_agreement(
    with_team=userA["team_id"],
    operation=tb.Operation.PRIVATE_RECORD_LINKAGE,
    session=session2,
)
print("Created usage Agreement.")


print("Data is in position.")
