#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


tb.initialize(api_token=tb.config.example_user2["token"], example=True)

# A second team (the current user's team) accesses the report which was
# defined by the first team.
report_asset = tb.Asset.find("college-acceptance-mongo")
if not report_asset:
    raise SystemExit("ERROR: Report not found.")

# NOTE:
# The report could also be shared without listing the asset if the first
# team just sends the asset ID to the second team.  Then they
# could just use an asset id sent by the data owner:
#
# report_asset = tb.Asset("a1b2c3d4-e5f6-a1b2-c3d4-e5f6a1b2c3d4")


# Create a job which runs the report
job = tb.create_job(
    job_name="Execute report",
    operation=tb.Operation.BLIND_QUERY,
    dataset=report_asset,
    preprocessor=tb.TabularPreprocessor.builder().all_columns(True),
)

if job.submit():
    job.wait_for_completion()

    if job.success:
        print("\n\nQuery results:")
        # tb.TableAsset.cast(job.result.asset).print_content()
        table = tb.TableAsset.cast(job.result.asset)
        print(table.dataframe)

        # Also save for this example
        filename = table.retrieve(save_as="out.zip", overwrite=True)
        print("\nResults also saved in file:", filename)
    else:
        raise SystemExit("Blind Query failed")
