#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import sys

import tripleblind as tb


tb.util.set_script_dir_current()
tb.initialize(api_token=tb.config.example_user3["token"])

hospital = tb.TableAsset.find(
    "DEMO - Hope Valley Hospital EHR", owned_by=tb.config.example_user3["team_id"]
)
pharmacy = tb.TableAsset.find("DEMO - Snowflake Pharmacy Prescriptions")
if not hospital or not pharmacy:
    print("ERROR: Unable to find datasets.")
    sys.exit(1)

# Perform a Private Set Intersection between the two databases by "address"
overlap = hospital.blind_join(
    intersect_with=pharmacy,
    match_column=["name", "patient name"],
    return_columns=["drug_name"],
    silent=True,
)

overlap.retrieve("overlap_exact.zip", overwrite=True)
print("Number of prescriptions: ", len(overlap.dataframe["drug_name"].value_counts()))
