#!/usr/bin/env python
# Copyright (c) TripleBlind Holdings, Inc. Confidential and Proprietary. All rights reserved.

import tripleblind as tb


# The report creator must communicate with each data provider to inform them
# of any new report so they can create agreements.
blind_report = tb.Asset.find(
    "[DEMO] Readmission Rate Report (Federated Report)", owned_by=3
)

# Access to all involved assets must be granted to the new report.  In this
# case, that means the patient and billed visit assets from each data provider.
tb.initialize(tb.config.example_user1["token"])
tb.Asset.find(
    "DEMO - Hospital Data Federation, Patient DB 1", owned=True
).add_agreement(with_team="ANY", operation=blind_report)
tb.Asset.find(
    "DEMO - Hospital Data Federation, Billed Visit DB 1", owned=True
).add_agreement(with_team="ANY", operation=blind_report)


# For simplicity, we will repeat this process in a single script. In a real
# scenario, each data provider would be responsible for creating their own
# agreements.

# Create agreements for user2 team
tb.initialize(tb.config.example_user2["token"])
tb.Asset.find(
    "DEMO - Hospital Data Federation, Patient DB 2", owned=True
).add_agreement(with_team="ANY", operation=blind_report)
tb.Asset.find(
    "DEMO - Hospital Data Federation, Billed Visit DB 2", owned=True
).add_agreement(with_team="ANY", operation=blind_report)

# Create agreements for user3's team
tb.initialize(tb.config.example_user3["token"])
tb.Asset.find(
    "DEMO - Hospital Data Federation, Patient DB 3", owned=True
).add_agreement(with_team="ANY", operation=blind_report)
tb.Asset.find(
    "DEMO - Hospital Data Federation, Billed Visit DB 3", owned=True
).add_agreement(with_team="ANY", operation=blind_report)

print("All Agreements are in place.")
